/**
 * MyKad Data Model
 * Represents Malaysian Identity Card information
 */
export interface MyKadData {
  name: string;
  icNumber: string;
  address: string; // Full address (combined)
  address1?: string; // Street address line 1
  address2?: string; // Street address line 2
  address3?: string; // Street address line 3
  postcode?: string; // Poskod (5 digits)
  city?: string; // Bandar/Daerah
  stateAddress?: string; // Negeri (from address, not IC)
  dateOfBirth?: string;
  gender?: string;
  state?: string; // State from IC number
  placeOfBirth?: string;
  religion?: string;
  race?: string;
  citizenship?: string;
}

/**
 * OCR Scan Result
 */
export interface ScanResult {
  success: boolean;
  data: MyKadData | null;
  rawText: string;
  confidence?: number;
  error?: string;
}

/**
 * IC Number Validation Result
 */
export interface ICValidation {
  valid: boolean;
  formatted?: string;
  dateOfBirth?: Date;
  gender?: 'Lelaki' | 'Perempuan';
  stateCode?: string;
  stateName?: string;
}
